Attribute VB_Name = "mdCircularDuplicate"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience function to create a circular duplicate

Sub CircularDuplicate(number As Double, angle As Double, isTotalAngle As Boolean, lineSet As ObjectSet)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim sketch As aSketch
Set sketch = Part.GetActiveSketch

Dim wp As aWorkplane
Set wp = Part.GetActiveWorkplane

If (isTotalAngle = True) Then
    angle = angle / number
End If

Pi = 3.14159265359

angle = angle * Pi / 180

Dim localZv As zVector
Set localZv = wp.GetLocalX.Cross(wp.GetLocalY)

Dim localZ As zDirection
Set localZ = localZv.GetDirection

Dim x As zVector
Dim y As zVector

Set x = app.GetClass("Vector").CreateVector(1, 0, 0)
Set y = app.GetClass("Vector").CreateVector(0, 1, 0)

Dim localorigin As zVector
Set localorigin = wp.GetLocalOrigin

Dim removeorigin As zMatrix
Set removeorigin = app.GetClass("Matrix").CreateTranslationMatrix(localorigin.GetNegative)

Dim addorigin As zMatrix
Set addorigin = app.GetClass("Matrix").CreateTranslationMatrix(localorigin)

For I = 1 To number - 1

    Dim rotate As zMatrix
    Set tempVectorX = x.rotate(localZ, angle * I)
    Set tempVectorY = y.rotate(localZ, angle * I)
    'Set rotate = app.GetClass("Matrix").CreateRotationMatrix(app.CreateDirectionVect(x.rotate(localZ, angle * I)), app.CreateDirectionVect(y.rotate(localZ, angle * I)))
    Set rotate = app.GetClass("Matrix").CreateRotationMatrix(tempVectorX.GetDirection, tempVectorY.GetDirection)
    
    Dim transmat As zMatrix
    Set transmat = addorigin.MultiplyByMatrix(rotate).MultiplyByMatrix(removeorigin)

    duplicatelines sketch, lineSet, transmat

Next I

End Sub

